$(document).ready(function() {

	
	$("#share").jsSocials({
        shares: [{ share: "email", label: "Share via Email", logo: "fas fa-envelope", url: url + "/quiz.php?id=" + unique_id}, { share: "facebook", label: "Share on Facebook", logo: "fab fa-facebook", url: url + "/quiz.php?id=" + unique_id}, { share: "whatsapp", label: "Share on WhatsApp", logo: "fab fa-whatsapp", url: url + "/quiz.php?id=" + unique_id}]
    });
	
	var clipboard = new ClipboardJS('.btn-copy');
	
	clipboard.on('success', function(e) {
	    
	    $(".btn-copy").html("Copied!").prop("disabled", true);
	
	    e.clearSelection();
	});
					
	function showError(msg) {
		$.toast({
			text: msg,
			bgColor : '#e74c3c',
			textColor : '#fff', 
			position : 'top-right'
		});
	}
	
	$(".btn-finish-quiz").click(function(e) {
		
		e.preventDefault();
		
		$(this).addClass("disabled");
		$(this).html("<i class='fas fa-circle-notch fa-spin'></i> Checking Results...");
							
		var that = $(this);
		
		var current_question = $(".quiz_q_container.current");
		var current_question_count = parseInt(current_question.attr("data-count"));
		
		// Check if the last question has answers checked too...
		if(current_question.find('input:checked').length > 0) {
			
			// Init the questions array
			var questionsArr = [];
			var questionObj = {
				question_id: "",
				answers: []
			};
									
			// Loop over all questions
			$.each($(".quiz_q_container"), function(i, question) {
				
				var question_id = $(question).attr("data-id");
				var question_answers = $(question).find(".quiz_q_answer");
				
				var questionObj = {
					question_id: question_id,
					answers: []
				};
				
				// Loop over all replies
				$.each(question_answers, function(j, answer) {
					
					var answer_id = $(answer).attr("data-id");
					
					// Is this answer 
					if($(answer).find('input:checked').length > 0) { 
															
						questionObj.answers.push(answer_id);
							
					}
					
				});
				
				// Add the object to array of questions
				questionsArr.push(questionObj);
					
			});
			
			setTimeout(function() {
										
				$.ajax({
					url: url + "/ajax/save-quiz.php",
					type: 'POST',
			        data: {
				       	quiz_id: current_quiz_id,
				       	questions_array: questionsArr
			        },
			        dataType: "json",
			        success: function (data) {
				        
				        that.removeClass("disabled");
				        
				        if(data.status == 1) {
					        
							var percent = parseFloat(data.percent);
							
							if(percent <= 25) {
								$(".quiz_success_container").addClass("over_0_to_25");
							} else if(percent <= 50) {
								$(".quiz_success_container").addClass("over_25_to_50");
							} else if(percent <= 75) {
								$(".quiz_success_container").addClass("over_50_to_75");
							} else if(percent <= 100) {
								$(".quiz_success_container").addClass("over_75_to_100");
							}
							
							$(".quiz_success_container").find(".percent_container").html("<span>" + percent + "<small>%</small></span>");
							$(".quiz_success_container").find(".good_replies_count").html(data.nb_good);
							$(".quiz_success_container").find(".wrong_replies_count").html(data.nb_wrong);
							
							
							$(".quiz_inner").hide();
							$(".quiz_success_container").fadeIn();
							
							$("#share2").jsSocials({
					            shares: [{ share: "email", label: "Share via Email", logo: "fas fa-envelope", url: url + "/quiz-result.php?id=" + data.unique_id}, { share: "facebook", label: "Share on Facebook", logo: "fab fa-facebook", url: url + "/quiz-result.php?id=" + data.unique_id}, { share: "whatsapp", label: "Share on WhatsApp", logo: "fab fa-whatsapp", url: url + "/quiz-result.php?id=" + data.unique_id}]
					        });
					        
				        } else {
					        showError(data.error);
					        that.html('<i class="fas fa-check"></i> Finish Quiz');
					        that.removeClass("disabled");
				        }
				        
				    }
				});
				
			}, 1000);

		} else {
			
			showError("Please check at least one answer...");
			that.html('<i class="fas fa-check"></i> Finish Quiz');
			that.removeClass("disabled");
			
		}
		
	});
	
	$(".btn-next-question").click(function(e) {
		
		e.preventDefault();
							
		var current_question = $(".quiz_q_container.current");
		var current_question_count = parseInt(current_question.attr("data-count"));
		
		if(current_question.find('input:checked').length > 0) {
			
			// We do have more questions ? We can show the next one...
			if(current_question_count < nb_questions) {
				
				var next_question_count = current_question_count + 1;
				var next_question = $(".quiz_q_container[data-count=" + next_question_count + "]");
				
				// Change classes to display the next question...
				current_question.removeClass("current");
				next_question.addClass("current");			
				
			}
		
		} else {
			
			showError("Please check at least one answer...");
			
		}
		
	});
	
	$(".btn-prev-question").click(function(e) {
		
		e.preventDefault();
							
		var current_question = $(".quiz_q_container.current");
		var current_question_count = parseInt(current_question.attr("data-count"));
		
		var prev_question_count = current_question_count - 1;
		var prev_question = $(".quiz_q_container[data-count=" + prev_question_count + "]");
		
		// Change classes to display the next question...
		current_question.removeClass("current");
		prev_question.addClass("current");			
			
		
	});
	
	$(".btn-login-fb").click(function(e) {
																	
		// Set a cookie for redirection
		$.cookie('redirect_quiz_id', current_quiz_id, { expires: 7, path: '/' });
							
	});
	
	$(".btn-play-quiz").click(function(e) {
		
		e.preventDefault();
							
		$(".take_quiz_container").hide();
		$(".quiz_questions_container").fadeIn();
		
	});
	
});